/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bits;

import emulator.hardware.bits.SharedBit;

public class EdgeDetector
extends SharedBit {
    private boolean trigger_level;
    private boolean actual_level;

    public EdgeDetector(boolean trigger_level, boolean initial_value) {
        this.trigger_level = trigger_level;
        this.actual_level = initial_value;
        super.setValue(false);
    }

    @Override
    public synchronized void setValue(boolean value) {
        if (this.actual_level != value) {
            this.actual_level = value;
            if (this.actual_level == this.trigger_level) {
                super.setValue(true);
            }
        }
    }

    @Override
    public synchronized boolean getValue() {
        boolean return_value = super.getValue();
        super.setValue(false);
        return return_value;
    }

    @Override
    public synchronized void toggle() {
        this.setValue(!this.actual_level);
    }
}

